/* ==========================================================

Please review the /readme.md for a more details.

========================================================== */

const jsonURL = document.querySelector("#product-detail-wrapper").dataset.path;

// URL from which to fetch the JSON data
const url = jsonURL;

// Function to render HTML template
function displayData(data) {
  const item = data.data.baseProductByPath.item;

  const productDetails = item.productDetails.map(detail => {
    return `<li><span>${detail.productDetailDisplayLabel}:</span> ${detail.productDetailFieldValue.plaintext}</li>`;
  }).join('');

  const applications = item.localizedProductFeature.applications;

  const specifications = item.productSpecification.map(spec => {
    return `<li><span>${spec.specificationLabel}</span> ${spec.specifcationMeasureImperial} | ${spec.specifcationMeasureMetric}</li>`;
  }).join('');

  const resources = item.productResources.map(res => {
    return res.resourceLabel ? `<li><span>${res.resourceLabel}:</span> <a title="${res.resourceLabel}" href="${res.resourceLink ? res.resourceLink._publishUrl : '#'}">${res.resourceLink ? res.resourceLink._publishUrl : '#'}</a></li>` : '';
  }).join('');

  // Sort and group productImages by imageCategory
  const sortedImages = [...item.productImages].sort((a, b) => a.imageCategory.localeCompare(b.imageCategory));

  const images = sortedImages.reduce((acc, imageGroup) => {
    const category = imageGroup.imageCategory;
    if (!acc[category]) {
      acc[category] = [];
    }
    acc[category].push(imageGroup);
    return acc;
  }, {});

  const imageHtml = Object.keys(images).map(category => {
    const variantsHtml = images[category].map(imageGroup => {
      const variantBlocks = imageGroup.imageVariants.map(variant => {
        return `
                    <li><a href="${variant.imageLink}" title="${variant.imageLabel}" target="_blank">${variant.imageLabel} <i class="fas fa-link"></i></a></li>
            `;
      }).join('');
      return `<div class="product-image-group"><img src="${imageGroup.imageThumbnail}" alt="${imageGroup.imageCategory}" /><ul>${variantBlocks}</ul></div>`;
    }).join('');
    return `<div class="image-section"><h3>${category}</h3><div class="product-image-variants">${variantsHtml}</div>`;
  }).join('');

  const template = `
                <div class="content">
                    <div class="product-section">
                        <div class="single-product">
                            <img class="api-image" src="${item.productImages[0].imageVariants[0].imageLink}">
                            <h3 class="api-text">${item.productSeries.seriesId}</h3>
                            <h4 class="api-text">${item.productDetails[1].productDetailFieldValue.plaintext}</h4>
                            <p class="api-text">${item.productSpecification[0].specificationEnglishFieldId}: ${item.productSpecification[0].specifcationMeasureImperial}</p>
                            <p class="api-text">${item.productSpecification[1].specificationEnglishFieldId}: ${item.productSpecification[1].specifcationMeasureImperial}</p>
                            <p class="api-text">${item.localizedProductFeature.powerTypeDisplayLabel}: ${item.localizedProductFeature.powerType}</p>
                            <p class="api-text">${item.productSpecification[3].specificationEnglishFieldId}: ${item.productSpecification[3].specifcationMeasureImperial}</p>
                            <p class="api-text">${item.productSpecification[2].specificationEnglishFieldId}: ${item.productSpecification[2].specifcationMeasureImperial}</p>
                            <div class="call-to-action">
                              <a href="${item.productResources[1].resourceLink._publishUrl}">Download Specifications</a>
                            </div>
                            <div class="call-to-action-plain">
                              <a href="${item.productResources[0].resourceLink._publishUrl}">Learn More at crown.com</a>                            
                            </div>
                        </div>
                    </div>
                </div>
            `;
  document.getElementById('data-container').innerHTML = template;
}

fetch(url)
  .then(response => {
    if (!response.ok) {
      throw new Error('Network response was not ok ' + response.statusText);
    }
    return response.json();
  })
  .then(data => {
    displayData(data);
  })
  .catch(error => {
    document.getElementById('data-container').innerHTML = '<p>Error loading data. Please try again later.</p>';
    console.error('Fetch error:', error);
  });
